<?xml version="1.0" encoding="ISO-8859-1"?>
<BK xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xsl:version="1.0">
  <xsl:for-each select="ONIXMessage/Product">
		<!-- <xsl:sort select="BICMainSubject" lang="en-gb"/>
		<xsl:sort select="PublicationDate" lang="en-gb"/> -->
		<Book>
			<xsl:variable name="form" select="ProductForm"/>
			<xsl:variable name="dt" select="PublicationDate"/>
			<xsl:variable name="bic" select="BICMainSubject"/>
			<xsl:variable name="isbn" select="ProductIdentifier[ProductIDType = '03']/IDValue"/>

			<image href="file:///./images/{$isbn}.jpg" />
			<title><xsl:value-of select="Title/TitleText"/></title>
			<author1>
				<xsl:value-of select="Contributor[SequenceNumber = '1']/NamesBeforeKey"/>&#160;<xsl:value-of select="Contributor[SequenceNumber = '1']/KeyNames"/>
			</author1>
			<author2>
				<xsl:value-of select="Contributor[SequenceNumber = '2']/NamesBeforeKey"/>&#160;<xsl:value-of select="Contributor[SequenceNumber = '2']/KeyNames"/>
			</author2>
			<author3>
				<xsl:value-of select="Contributor[SequenceNumber = '3']/NamesBeforeKey"/>&#160;<xsl:value-of select="Contributor[SequenceNumber = '3']/KeyNames"/>
			</author3>
			<blurb>
				<xsl:value-of select="OtherText[TextTypeCode = '01']/Text" />
			</blurb>
			<bio1><xsl:value-of select="Contributor[SequenceNumber = '1']/BiographicalNote"/></bio1>
			<bio2><xsl:value-of select="Contributor[SequenceNumber = '2']/BiographicalNote"/></bio2>
			<bio3><xsl:value-of select="Contributor[SequenceNumber = '3']/BiographicalNote"/></bio3>
			<sales>
				<xsl:value-of select="OtherText[TextTypeCode = '25']/Text" />
			</sales>
			<isbn><xsl:value-of select="concat(substring($isbn,1,3), ' ',substring($isbn,4,1), ' ',substring($isbn,5,5), ' ', substring($isbn,10,3), ' ', substring($isbn, 13,1))"/></isbn>
			<xsl:variable name="bw" select="Illustrations[IllustrationType = '01']/Number" />
			<xsl:variable name="col" select="Illustrations[IllustrationType = '02']/Number"/>
			<xsl:if test="$col>0">
				<illocol>
					<xsl:value-of select ="$col"/> colour illustrations
				</illocol>
			</xsl:if>
			<xsl:if test="$bw>0">
				<illobw>
					<xsl:value-of select ="$bw"/> mono illustrations
				</illobw>
			</xsl:if>
			<pages><xsl:value-of select="NumberOfPages"/> pages</pages>
			<dim>
				<xsl:if test="Measure[MeasureTypeCode='01']/Measurement">
					<xsl:value-of select="Measure[MeasureTypeCode='01']/Measurement"/><xsl:value-of select="Measure[MeasureTypeCode='01']/MeasureUnitCode"/> x <xsl:value-of select="Measure[MeasureTypeCode='02']/Measurement"/><xsl:value-of select="Measure[MeasureTypeCode='02']/MeasureUnitCode"/>
				</xsl:if>
			</dim>
			<price><xsl:value-of select="SupplyDetail/Price/PriceAmount"/></price>
			<format>
				<xsl:choose>
					<xsl:when test="$form = 'BC'">PB</xsl:when>
					<xsl:when test="$form = 'BB'">HB</xsl:when>
					<xsl:when test="$form = 'DG'">Ebook</xsl:when>
					<xsl:otherwise><xsl:value-of select="$form"/></xsl:otherwise>
				</xsl:choose>
			</format>
			<cat>
				<xsl:choose>
					<xsl:when test="$bic = 'FM'">Fantasy</xsl:when>
					<xsl:when test="$bic = 'F'">Fiction</xsl:when>
					<xsl:otherwise><xsl:value-of select="$bic"/></xsl:otherwise>
				</xsl:choose>
			</cat>
			<month>
			<xsl:variable name="month" select ="substring($dt,5,2)"/>
			<xsl:choose>
				<xsl:when test="$month = '01'">Jan</xsl:when>
				<xsl:when test="$month = '02'">Feb</xsl:when>
				<xsl:when test="$month = '03'">Mar</xsl:when>
				<xsl:when test="$month = '04'">Apr</xsl:when>
				<xsl:when test="$month = '05'">May</xsl:when>
				<xsl:when test="$month = '06'">Jun</xsl:when>
				<xsl:when test="$month = '07'">Jul</xsl:when>
				<xsl:when test="$month = '08'">Aug</xsl:when>
				<xsl:when test="$month = '09'">Sep</xsl:when>
				<xsl:when test="$month = '10'">Oct</xsl:when>
				<xsl:when test="$month = '11'">Nov</xsl:when>
				<xsl:when test="$month = '12'">Dec</xsl:when>
			</xsl:choose></month>
			<year><xsl:value-of select="substring($dt,1,4)"/></year>
		</Book>
  </xsl:for-each>
</BK>
